/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Shopkeeper Name")
@Description(value={"Returns the name of a shopkeeper."})
@Examples(value={"send \"%the name of the shopkeeper with id 1\""})
public class ExprKeeperName
extends SimpleExpression<String> {
    private Expression<Integer> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "name of shopkeeper with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Shopkeeper shopkeeper;
        if (this.id.getSingle(e) == null || (shopkeeper = ShopkeepersHook.shopkeeperRegistry.getShopkeeperById(((Integer)this.id.getSingle(e)).intValue())) == null) {
            return null;
        }
        return new String[]{shopkeeper.getName()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            Shopkeeper shopkeeper;
            if (this.id.getSingle(e) == null || (shopkeeper = ShopkeepersHook.shopkeeperRegistry.getShopkeeperById(((Integer)this.id.getSingle(e)).intValue())) == null) {
                return;
            }
            shopkeeper.setName((String)delta[0]);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{String.class}) : null;
    }

    static {
        Skript.registerExpression(ExprKeeperName.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] name of [the] [shop]keeper [with ID] %integer%"});
    }
}

