/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Shopkeeper Exists")
@Description(value={"Checks if a shopkeeper with a certain ID exists."})
@Examples(value={"if shopkeeper with id 1 exists:"})
public class CondKeeperExists
extends Condition {
    private Expression<Integer> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "keeper wid ID " + this.id.toString(e, b) + " exists";
    }

    public boolean check(Event e) {
        if (this.id.getSingle(e) == null) {
            return this.isNegated();
        }
        return ShopkeepersHook.shopkeeperRegistry.getShopkeeperById(((Integer)this.id.getSingle(e)).intValue()) == null == this.isNegated();
    }

    static {
        Skript.registerCondition(CondKeeperExists.class, (String[])new String[]{"[a] [shop]keeper [with ID] %integer% exists", "[a] [shop]keeper [with ID] %integer% does(n't| not) exist"});
    }
}

