/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopchest.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import de.epiceric.shopchest.shop.Shop;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopchest.ShopChestHook;

@Name(value="ShopChest - Shop Vendor")
@Description(value={"Returns the vendor of a shop."})
@Examples(value={"send \"%the vendor of shop with id (shop at player)%\""})
public class ExprShopVendor
extends SimpleExpression<OfflinePlayer> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the vendor of the shop with id " + this.id.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        Shop shop;
        if (this.id.getSingle(e) == null || (shop = ShopChestHook.getShop(((Number)this.id.getSingle(e)).intValue())) == null) {
            return null;
        }
        return new OfflinePlayer[]{shop.getVendor()};
    }

    static {
        Skript.registerExpression(ExprShopVendor.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] (vendor|owner) of [the] [ShopChest] shop [with ID] %number%"});
    }
}

