/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopchest.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import de.epiceric.shopchest.shop.Shop;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopchest.ShopChestHook;

@Name(value="ShopChest - All Shops of Player")
@Description(value={"Returns the IDs of all shops of a  Player."})
@Examples(value={"send \"%all shops of player%\""})
public class ExprPlayerShops
extends SimpleExpression<Number> {
    private Expression<Player> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "ids of all shops of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (Number[])Arrays.stream(ShopChestHook.shopUtils.getShops()).filter(shop -> shop.getVendor().equals(this.player.getSingle(e))).map(Shop::getID).toArray(Number[]::new);
    }

    static {
        Skript.registerExpression(ExprPlayerShops.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [IDs of all [the]] [ShopChest] shops of %offlineplayer%", "[all of] [[the] IDs of [all]] %offlineplayer%'s [ShopChest] shops"});
    }
}

