/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.pvplevels.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.pvplevels.PvPLevelsHook;

@Name(value="PvPLevels - KDR of Player")
@Description(value={"Returns the kill-death ratio of a player."})
@Examples(value={"send \"%pvp KDR of player%\""})
public class ExprKDR
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "kdr of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        double kdr = (double)PvPLevelsHook.pvpLevelsAPI.CurrentKillsOfflinePlayer((OfflinePlayer)this.player.getSingle(e)) / (double)(PvPLevelsHook.pvpLevelsAPI.CurrentDeathsOfflinePlayer((OfflinePlayer)this.player.getSingle(e)) == 0 ? 1 : PvPLevelsHook.pvpLevelsAPI.CurrentDeathsOfflinePlayer((OfflinePlayer)this.player.getSingle(e)));
        return new Number[]{kdr};
    }

    static {
        Skript.registerExpression(ExprKDR.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] PvP[Levels] (kd[r]|kill death ratio) of %offlineplayer%", "%offlineplayer%'s PvP[Levels] (kd[r]|kill death ratio)"});
    }
}

