/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot Owner")
@Description(value={"Returns the owner of a plot."})
@Examples(value={"send \"%the owner of the plot with id (id of plot at player)%\""})
public class ExprPlotOwner
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> id;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "owner of plot with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        return (OfflinePlayer[])plot.getOwners().stream().map(Bukkit::getOfflinePlayer).toArray(OfflinePlayer[]::new);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Plot plot;
        if (this.id.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return;
        }
        OfflinePlayer player = (OfflinePlayer)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            plot.setOwner(player.getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class}) : null;
    }

    static {
        Skript.registerExpression(ExprPlotOwner.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] owner[s] of [the] [PlotSquared] plot [with ID] %string%"});
    }
}

