/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot ID at location")
@Description(value={"Returns the ID of a plot at a location."})
@Examples(value={"send \"%the ID of the plot at player%\""})
public class ExprPlotID
extends SimpleExpression<String> {
    private Expression<Location> loc;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.loc = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "id of plot at location " + this.loc.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.loc.getSingle(e) == null) {
            return null;
        }
        for (Plot plot : PlotSquaredHook.plotAPI.getAllPlots()) {
            if (!plot.getArea().contains((int)((Location)this.loc.getSingle(e)).getX(), (int)((Location)this.loc.getSingle(e)).getZ())) continue;
            return new String[]{plot.getId().toString()};
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprPlotID.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [ID of [the]] [PlotSquared] plot at %location%"});
    }
}

