/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.intellectualsites.plotsquared.plot.flag.Flag;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot Flags")
@Description(value={"Returns the set flags in a plot."})
@Examples(value={"send \"%the flags of the plot with id (id of plot at player)%\""})
public class ExprPlotFlags
extends SimpleExpression<String> {
    private Expression<String> id;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "flags of plot of with id " + this.id.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        return (String[])plot.getFlags().keySet().stream().map(Flag::getName).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprPlotFlags.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [set] flags of [the] [PlotSquared] plot [with ID] %string%"});
    }
}

