/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.intellectualsites.plotsquared.plot.flag.Flags;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot Flag Value")
@Description(value={"Returns the value of a flag in a plot."})
@Examples(value={"send \"%the value of flag {flag} in the plot with id (id of plot at player)%\""})
public class ExprFlagValue
extends SimpleExpression<Object> {
    private Expression<String> id;
    private Expression<String> flag;

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[1];
        this.flag = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the value of flag " + this.flag.toString(e, b) + " in plot with id " + this.id.toString(e, b);
    }

    @Nullable
    protected Object[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || this.flag.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        return new Object[]{plot.getFlags().get(Flags.getFlag((String)((String)this.flag.getSingle(e))))};
    }

    static {
        Skript.registerExpression(ExprFlagValue.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[[the] value of] [the] flag %string% (in|for) [the] [PlotSquared] plot [with ID] %string%"});
    }
}

