/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Denied Players of Plot")
@Description(value={"Returns the denied players of a plot."})
@Examples(value={"send \"%the denied players of the plot with id (id of plot at player)%\""})
public class ExprDenied
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> id;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "denied players of plot with id " + this.id.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        return (OfflinePlayer[])plot.getDenied().stream().map(Bukkit::getOfflinePlayer).toArray(OfflinePlayer[]::new);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.id.getSingle(e) == null) {
            return;
        }
        OfflinePlayer player = (OfflinePlayer)delta[0];
        Plot plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e));
        if (plot == null) {
            return;
        }
        if (mode == Changer.ChangeMode.ADD) {
            plot.addDenied(player.getUniqueId());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            plot.removeDenied(player.getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class}) : null;
    }

    static {
        Skript.registerExpression(ExprDenied.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] denied players of [the] [PlotSquared] plot [with ID] %string%"});
    }
}

