/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Is Player in Plot")
@Description(value={"Checks if a player is in a plot."})
@Examples(value={"if player is in a plot:"})
public class CondInPlot
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is in a plot";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return PlotSquaredHook.plotAPI.wrapPlayer(((Player)this.player.getSingle(e)).getUniqueId()).getCurrentPlot() != null == this.isNegated();
    }

    static {
        Skript.registerCondition(CondInPlot.class, (String[])new String[]{"%player% is [currently] in [a] [PlotSquared] plot", "%player% is(n't| not) [currently] in [a] [PlotSquared] plot"});
    }
}

