/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.playerpoints.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.playerpoints.PlayerPointsHook;

@Name(value="PlayerPoints - Balance")
@Description(value={"Returns the PlayerPoints balance of a player."})
@Examples(value={"send \"%the player points balance of player%\""})
public class ExprPointsBalance
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the player points balance of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{PlayerPointsHook.playerPointsAPI.look(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.player.getSingle(e) == null) {
            return;
        }
        int amount = ((Number)delta[0]).intValue();
        if (mode == Changer.ChangeMode.SET) {
            PlayerPointsHook.playerPointsAPI.set(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        } else if (mode == Changer.ChangeMode.ADD) {
            PlayerPointsHook.playerPointsAPI.give(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            PlayerPointsHook.playerPointsAPI.take(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        } else if (mode == Changer.ChangeMode.RESET) {
            PlayerPointsHook.playerPointsAPI.reset(((OfflinePlayer)this.player.getSingle(e)).getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprPointsBalance.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [Player Points] (bal[ance]|points) of %offlineplayer%", "%offlineplayer%'s [Player Points] (bal[ance]|points)"});
    }
}

