/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Party Leader")
@Description(value={"Returns the leader of a party."})
@Examples(value={"send \"%the leader of the party named \"cool\"%\""})
public class ExprLeader
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "leader of party named " + this.name.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        if (this.name.getSingle(e) == null) {
            return null;
        }
        return new OfflinePlayer[]{Bukkit.getOfflinePlayer((UUID)PartiesHook.partiesAPI.getPartyLeader((String)this.name.getSingle(e)))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer newLeader = (OfflinePlayer)delta[0];
        if (this.name.getSingle(e) == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            PartiesHook.partyHandler.loadParty((String)this.name.getSingle(e)).setLeader(newLeader.getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class}) : null;
    }

    static {
        Skript.registerExpression(ExprLeader.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] leader of [the] party [(named|with name)] %string%", "[the] party [(named|with name)] %string%'s leader"});
    }
}

