/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lwc.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.griefcraft.model.Protection;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import us._donut_.skuniversal.lwc.LWCHook;

@Name(value="LWC - Owner")
@Description(value={"Returns the owner of a block."})
@Examples(value={"send \"%the owner of the clicked block%\""})
public class ExprLWCOwner
extends SimpleExpression<OfflinePlayer> {
    private Expression<Block> block;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the owner of block " + this.block.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        if (this.block.getSingle(e) == null) {
            return null;
        }
        Protection protection = LWCHook.lwc.findProtection((Block)this.block.getSingle(e));
        if (protection == null) {
            return null;
        }
        String[] playerNameAndUUID = protection.getFormattedOwnerPlayerName().split(" ");
        return new OfflinePlayer[]{Bukkit.getOfflinePlayer((String)playerNameAndUUID[0])};
    }

    static {
        Skript.registerExpression(ExprLWCOwner.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [LWC] owner of %block%", "%block%'s [LWC] owner"});
    }
}

