/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lwc.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import us._donut_.skuniversal.lwc.LWCHook;

@Name(value="LWC - Is Block Protected")
@Description(value={"Checks if a block is protected."})
@Examples(value={"if clicked block is protected:"})
public class CondProtected
extends Condition {
    private Expression<Block> block;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "block " + this.block.toString(e, b) + " is protected";
    }

    public boolean check(Event e) {
        if (this.block.getSingle(e) == null) {
            return this.isNegated();
        }
        return LWCHook.lwc.findProtection((Block)this.block.getSingle(e)) == null == this.isNegated();
    }

    static {
        Skript.registerCondition(CondProtected.class, (String[])new String[]{"%block% is (locked|protected) [by LWC]", "%block% is(n't| not) (locked|protected) [by LWC]"});
    }
}

