/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lwc.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import us._donut_.skuniversal.lwc.LWCHook;

@Name(value="LWC - Is Block Protectable")
@Description(value={"Checks if a block is protectable."})
@Examples(value={"if the clicked block is protectable:"})
public class CondProtectable
extends Condition {
    private Expression<Block> block;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "block " + this.block.toString(e, b) + " is protectable";
    }

    public boolean check(Event e) {
        if (this.block.getSingle(e) == null) {
            return this.isNegated();
        }
        return LWCHook.lwc.isProtectable((Block)this.block.getSingle(e)) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondProtectable.class, (String[])new String[]{"%block% is (lockable|protectable) [by LWC]", "%block% is(n't| not) (lockable|protectable) [by LWC]"});
    }
}

