/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.luckperms.LuckPermsHook;

@Name(value="LuckPerms - Permissions of Player")
@Description(value={"Returns the permissions of a player."})
@Examples(value={"send \"%the luckperms permissions of player%\""})
public class ExprPlayerPermissions
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "luckperms permissions of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        User user = LuckPermsHook.luckpermsAPI.getUser(((Player)this.player.getSingle(e)).getUniqueId());
        return user == null ? null : (String[])user.getPermissions().stream().map(Node::getPermission).toArray(String[]::new);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.player.getSingle(e) == null) {
            return;
        }
        User user = LuckPermsHook.luckpermsAPI.getUser(((Player)this.player.getSingle(e)).getUniqueId());
        if (user == null) {
            return;
        }
        if (mode == Changer.ChangeMode.RESET) {
            user.clearNodes();
        } else if (mode == Changer.ChangeMode.DELETE) {
            user.clearNodes();
        } else if (mode == Changer.ChangeMode.ADD) {
            user.setPermission(LuckPermsHook.luckpermsAPI.getNodeFactory().newBuilder((String)delta[0]).build());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            user.unsetPermission(LuckPermsHook.luckpermsAPI.getNodeFactory().newBuilder((String)delta[0]).build());
        }
        LuckPermsHook.luckpermsAPI.getUserManager().saveUser(user);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{String.class}) : null;
    }

    static {
        Skript.registerExpression(ExprPlayerPermissions.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [LuckPerm[s]] perm[ission][s] of [player] %player%", "[player] %player%'s [LuckPerm[s]] perm[ission][s]"});
    }
}

