/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.Node;
import org.bukkit.event.Event;
import us._donut_.skuniversal.luckperms.LuckPermsHook;

@Name(value="LuckPerms - Permissions of Group")
@Description(value={"Returns the permissions of a group."})
@Examples(value={"set {default::perms::*} to the permissions of the luckperms group \"default\""})
public class ExprGroupPermissions
extends SimpleExpression<String> {
    private Expression<String> group;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.group = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "luckperms permissions of group " + this.group.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.group.getSingle(e) == null) {
            return null;
        }
        Group lpGroup = LuckPermsHook.luckpermsAPI.getGroup((String)this.group.getSingle(e));
        return lpGroup == null ? null : (String[])lpGroup.getPermissions().stream().map(Node::getPermission).toArray(String[]::new);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.group.getSingle(e) == null) {
            return;
        }
        Group groupBeingChanged = LuckPermsHook.luckpermsAPI.getGroup((String)this.group.getSingle(e));
        if (groupBeingChanged == null) {
            return;
        }
        if (mode == Changer.ChangeMode.RESET) {
            groupBeingChanged.clearNodes();
        } else if (mode == Changer.ChangeMode.DELETE) {
            groupBeingChanged.clearNodes();
        } else if (mode == Changer.ChangeMode.ADD) {
            groupBeingChanged.setPermission(LuckPermsHook.luckpermsAPI.getNodeFactory().newBuilder((String)delta[0]).build());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            groupBeingChanged.unsetPermission(LuckPermsHook.luckpermsAPI.getNodeFactory().newBuilder((String)delta[0]).build());
        }
        LuckPermsHook.luckpermsAPI.getGroupManager().saveGroup(groupBeingChanged);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{String.class}) : null;
    }

    static {
        Skript.registerExpression(ExprGroupPermissions.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] perm[ission][s] of [the] [LuckPerm[s]] group [(named|with name)] %string%", "[all of] [the] [LuckPerm[s]] group [(named|with name)] %string%'s perm[ission][s]"});
    }
}

