/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lockettepro.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.crafter.mc.lockettepro.LocketteProAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;

@Name(value="LockettePro - Block Owner")
@Description(value={"Returns the owner of a block."})
@Examples(value={"send \"%the owner of the clicked block%\""})
public class ExprLocketteProOwner
extends SimpleExpression<OfflinePlayer> {
    private Expression<Block> block;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "owner of block " + this.block.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        if (this.block.getSingle(e) == null) {
            return null;
        }
        if (!LocketteProAPI.isLocked((Block)((Block)this.block.getSingle(e)))) {
            return null;
        }
        for (int x = ((Block)this.block.getSingle(e)).getX() - 1; x <= ((Block)this.block.getSingle(e)).getX() + 1; ++x) {
            for (int y = ((Block)this.block.getSingle(e)).getY() - 1; y <= ((Block)this.block.getSingle(e)).getY() + 1; ++y) {
                for (int z = ((Block)this.block.getSingle(e)).getZ() - 1; z <= ((Block)this.block.getSingle(e)).getZ() + 1; ++z) {
                    Location loc = new Location(((Block)this.block.getSingle(e)).getWorld(), (double)x, (double)y, (double)z);
                    if (!LocketteProAPI.isLockSign((Block)loc.getBlock())) continue;
                    Sign sign = (Sign)loc.getBlock().getState();
                    return new OfflinePlayer[]{Bukkit.getOfflinePlayer((String)sign.getLine(1))};
                }
            }
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprLocketteProOwner.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[LockettePro] owner of %block%", "%block%'s [LockettePro] owner"});
    }
}

