/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lockette.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.yi.acru.bukkit.Lockette.Lockette;

@Name(value="Lockette - Block Owner")
@Description(value={"Returns the owner of a block."})
@Examples(value={"send \"%owner of the clicked block%\""})
public class ExprLocketteOwner
extends SimpleExpression<OfflinePlayer> {
    private Expression<Block> block;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "owner of block " + this.block.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        OfflinePlayer[] offlinePlayerArray;
        if (this.block.getSingle(e) == null) {
            return null;
        }
        UUID owner = Lockette.getProtectedOwnerUUID((Block)((Block)this.block.getSingle(e)));
        if (owner == null) {
            offlinePlayerArray = null;
        } else {
            OfflinePlayer[] offlinePlayerArray2 = new OfflinePlayer[1];
            offlinePlayerArray = offlinePlayerArray2;
            offlinePlayerArray2[0] = Bukkit.getOfflinePlayer((UUID)owner);
        }
        return offlinePlayerArray;
    }

    static {
        Skript.registerExpression(ExprLocketteOwner.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [Lockette] owner of %block%", "%block%'s [Lockette] owner"});
    }
}

