/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Remaining Claim Blocks")
@Description(value={"Returns the remaining claim blocks of a player."})
@Examples(value={"send \"%the remaining claim blocks of player%\""})
public class ExprRemainingClaimBlocks
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "remaining claim blocks of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).getRemainingClaimBlocks()};
    }

    static {
        Skript.registerExpression(ExprRemainingClaimBlocks.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] remaining [G[rief]P[revention]] [claim] blocks of %offlineplayer%", "%offlineplayer%'s remaining [G[rief]P[revention]] [claim] blocks"});
    }
}

