/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Explosion Status")
@Description(value={"Returns the explosion status of a claim."})
@Examples(value={"send \"%the explosion status of the claim with id (id of the basic claim at player)%\""})
public class ExprExplosionStatus
extends SimpleExpression<Boolean> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "explosion status of claim with id " + this.id.toString(e, b);
    }

    @Nullable
    protected Boolean[] get(Event e) {
        Boolean[] booleanArray;
        Claim claim = GriefPreventionHook.getClaim(((Number)this.id.getSingle(e)).longValue());
        if (claim == null) {
            booleanArray = null;
        } else {
            Boolean[] booleanArray2 = new Boolean[1];
            booleanArray = booleanArray2;
            booleanArray2[0] = claim.areExplosivesAllowed;
        }
        return booleanArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Boolean status = (Boolean)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Claim claim = GriefPreventionHook.getClaim(((Number)this.id.getSingle(e)).longValue());
            if (claim == null) {
                return;
            }
            claim.areExplosivesAllowed = status;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprExplosionStatus.class, Boolean.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] explosion[s] status of [the] [G[rief]P[revention]] claim [with ID] %number%"});
    }
}

