/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Claim Block Limit")
@Description(value={"Returns the claim block limit of a player."})
@Examples(value={"send \"%the claim block limit of player%\""})
public class ExprClaimBlockLimit
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "claim block limit of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).getAccruedClaimBlocksLimit()};
    }

    static {
        Skript.registerExpression(ExprClaimBlockLimit.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [G[rief]P[revention]] [claim] block limit of %offlineplayer%", "%offlineplayer%'s [G[rief]P[revention]] [claim] block limit"});
    }
}

