/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention;

import ch.njol.skript.Skript;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.events.ClaimDeletedEvent;
import me.ryanhamshire.GriefPrevention.events.ClaimExpirationEvent;
import me.ryanhamshire.GriefPrevention.events.PreventBlockBreakEvent;
import me.ryanhamshire.GriefPrevention.events.PreventPvPEvent;
import me.ryanhamshire.GriefPrevention.events.SaveTrappedPlayerEvent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import us._donut_.skuniversal.SkUniversalEvent;

public class GriefPreventionHook {
    public static DataStore dataStore = GriefPrevention.instance.dataStore;

    public static Claim getClaim(@Nullable Long id) {
        if (id == null) {
            return null;
        }
        Claim claim = dataStore.getClaim(id.longValue());
        if (claim != null) {
            return claim;
        }
        for (Claim aClaim : dataStore.getClaims()) {
            for (Claim childClaim : aClaim.children) {
                if (!childClaim.getID().equals(id)) continue;
                return childClaim;
            }
        }
        return null;
    }

    static {
        Skript.registerEvent((String)"GriefPrevention - Claim Deletion", SkUniversalEvent.class, ClaimDeletedEvent.class, (String[])new String[]{"[G[rief]P[revention]] claim delet(e|ion)"}).description(new String[]{"Called when a claim is deleted."}).examples(new String[]{"on claim deletion:", "\tbroadcast \"Claim %event-number% was deleted!\""});
        EventValues.registerEventValue(ClaimDeletedEvent.class, Number.class, (Getter)new Getter<Number, ClaimDeletedEvent>(){

            public Number get(ClaimDeletedEvent e) {
                return e.getClaim().getID();
            }
        }, (int)0);
        Skript.registerEvent((String)"GriefPrevention - Claim Expiration", SkUniversalEvent.class, ClaimExpirationEvent.class, (String[])new String[]{"[G[rief]P[revention]] claim expir(e|ation)"}).description(new String[]{"Called when a claim expires."}).examples(new String[]{"on claim expiration:", "\tbroadcast \"Claim %event-number% has expired!\""});
        EventValues.registerEventValue(ClaimExpirationEvent.class, Number.class, (Getter)new Getter<Number, ClaimExpirationEvent>(){

            public Number get(ClaimExpirationEvent e) {
                return e.getClaim().getID();
            }
        }, (int)0);
        Skript.registerEvent((String)"GriefPrevention - Prevent Block Break", SkUniversalEvent.class, PreventBlockBreakEvent.class, (String[])new String[]{"[G[rief]P[revention]] prevent block [from] break[ing]"}).description(new String[]{"Called when a player tries to break a block."}).examples(new String[]{"on prevent block from breaking:", "\tbroadcast \"%player% tried to grief!\""});
        EventValues.registerEventValue(PreventBlockBreakEvent.class, Player.class, (Getter)new Getter<Player, PreventBlockBreakEvent>(){

            public Player get(PreventBlockBreakEvent e) {
                return e.getInnerEvent().getPlayer();
            }
        }, (int)0);
        Skript.registerEvent((String)"GriefPrevention - Prevent PvP", SkUniversalEvent.class, PreventPvPEvent.class, (String[])new String[]{"[G[rief]P[revention]] prevent pvp"}).description(new String[]{"Called when PvP is prevented."}).examples(new String[]{"on prevent pvp:", "\tbroadcast \"No PvP allowed!\""});
        Skript.registerEvent((String)"GriefPrevention - Protect Drops", SkUniversalEvent.class, PreventPvPEvent.class, (String[])new String[]{"[G[rief]P[revention]] protect [death] drops"}).description(new String[]{"Called when death drops are protected."}).examples(new String[]{"on protect drops:", "\tbroadcast \"These drops are protected!\""});
        Skript.registerEvent((String)"GriefPrevention - Save Trapped Player", SkUniversalEvent.class, SaveTrappedPlayerEvent.class, (String[])new String[]{"[G[rief]P[revention]] save trapped player"}).description(new String[]{"Called when a trapped player is saved."}).examples(new String[]{"on save trapped player:", "\tbroadcast \"A player was saved from claim %event-number%!\""});
        EventValues.registerEventValue(SaveTrappedPlayerEvent.class, Number.class, (Getter)new Getter<Number, SaveTrappedPlayerEvent>(){

            public Number get(SaveTrappedPlayerEvent e) {
                return e.getClaim().getID();
            }
        }, (int)0);
        EventValues.registerEventValue(SaveTrappedPlayerEvent.class, Location.class, (Getter)new Getter<Location, SaveTrappedPlayerEvent>(){

            public Location get(SaveTrappedPlayerEvent e) {
                return e.getDestination();
            }
        }, (int)0);
    }
}

