/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.expressions;

import at.pavlov.cannons.cannon.CannonManager;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Cannons - Cannons of Player")
@Description(value={"Returns the IDs of the cannons a player has created."})
@Examples(value={"send \"%player% has built %cannons of player%\""})
public class ExprCannonsOfPlayer
extends SimpleExpression<String> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the cannons of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (String[])CannonManager.getCannonList().values().stream().filter(cannon -> cannon.getOwner().equals(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())).map(cannon -> cannon.getUID().toString()).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprCannonsOfPlayer.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)]] [IDs of [the]] cannons [of] %offlineplayer%", "[all of] [[the] IDs of]] %offlineplayer%'s cannons"});
    }
}

