/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.expressions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Cannon Temperature")
@Description(value={"Returns the temperature of a cannon."})
@Examples(value={"send \"%the temperature of the cannon with id (id of cannon at player)%\""})
public class ExprCannonTemp
extends SimpleExpression<Number> {
    private Expression<String> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the temperature of the cannon with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Cannon cannon;
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return null;
        }
        return new Number[]{cannon.getTemperature()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Cannon cannon;
        double newTemp = ((Number)delta[0]).doubleValue();
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            cannon.setTemperature(newTemp);
        } else if (mode == Changer.ChangeMode.ADD) {
            cannon.setTemperature(cannon.getTemperature() + newTemp);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            cannon.setTemperature(cannon.getTemperature() - newTemp);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprCannonTemp.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] temp[erature] of [the] cannon [with ID] %string%"});
    }
}

