/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bitcoin.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.bitcoin.BitcoinHook;

@Name(value="Bitcoin - Mining Puzzles Solved")
@Description(value={"Returns the amount of bitcoin mining puzzles solved by a player."})
@Examples(value={"send \"%the amount of bitcoin puzzles solved by player%\""})
public class ExprBitcoinPuzzlesSolved
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the amount of bitcoin puzzles solved by player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{BitcoinHook.bitcoinAPI.getPuzzlesSolved(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())};
    }

    static {
        Skript.registerExpression(ExprBitcoinPuzzlesSolved.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [(amount|number) of] [bitcoin] [min(e|ing)] puzzles solved by %offlineplayer%"});
    }
}

