/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bedwars.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.MineHome.Bedwars.Game.GameManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Bedwars - Is Playing")
@Description(value={"Checks if a player is in a Bedwars game."})
@Examples(value={"if {_player} is playing in a Bedwars game:"})
public class CondInGame
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is in Bedwars game";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return GameManager.inGame((Player)((Player)this.player.getSingle(e))) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondInGame.class, (String[])new String[]{"%player% is [currently] [playing] in [a] [Bedwars] game", "%player% is(n't| not) [currently] [playing] in [a] [Bedwars] game"});
    }
}

