/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bedwars.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.MineHome.Bedwars.Game.GameManager;
import org.bukkit.event.Event;

@Name(value="Bedwars - Is Game Startable")
@Description(value={"Checks if a game is able to start."})
@Examples(value={"if bedwars game \"Game1\" is startable:"})
public class CondGameStartable
extends Condition {
    private Expression<String> game;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.game = e[0];
        this.setNegated(matchedPattern == 2 || matchedPattern == 3);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "Bedwars game " + this.game.toString(e, b) + " is startable";
    }

    public boolean check(Event e) {
        if (this.game.getSingle(e) == null) {
            return this.isNegated();
        }
        return GameManager.getGame((String)((String)this.game.getSingle(e))).isStartable() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondGameStartable.class, (String[])new String[]{"[the] [Bedwars] game [(named|with name)] %string% is (startable|able to start)", "[the] [Bedwars] game [(named|with name)] %string% can be started", "[the] [Bedwars] game [(named|with name)] %string% is(n't| not) (startable|able to start)", "[the] [Bedwars] game [(named|with name)] %string% can('t|not) be started"});
    }
}

