/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.autorank.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.armar.plugins.autorank.pathbuilder.Path;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.autorank.AutorankHook;

@Name(value="Autorank - Completed Paths")
@Description(value={"Returns list of the completed paths of a player."})
@Examples(value={"send \"You have completed these paths: %completed paths of player%\""})
public class ExprCompletedPaths
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "completed paths of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (String[])AutorankHook.autorankAPI.getCompletedPaths(((Player)this.player.getSingle(e)).getUniqueId()).stream().map(Path::getDisplayName).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprCompletedPaths.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] (completed|finished) [Autorank] paths of %player%", "[all of] %player%'s (completed|finished) [Autorank] paths"});
    }
}

