/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.slimefun.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.Research;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Slimefun - Has Unlocked Research")
@Description(value={"Checks if a player has a research unlocked."})
@Examples(value={"if the player has unlocked the research with id 2048:"})
public class CondHasResearch
extends Condition {
    private Expression<OfflinePlayer> player;
    private Expression<Integer> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.id = e[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " has research " + this.id.toString(e, b);
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null || this.id.getSingle(e) == null) {
            return this.isNegated();
        }
        return Research.getByID((int)((Integer)this.id.getSingle(e))).hasUnlocked(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondHasResearch.class, (String[])new String[]{"offlineplayer% has [unlocked] [the] [Slimefun] research [with ID] %integer%", "offlineplayer% has(n't| not) [unlocked] [the] [Slimefun] research [with ID] %integer%"});
    }
}

