/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.skywars_cookloco.expressions;

import ak.CookLoco.SkyWars.arena.Arena;
import ak.CookLoco.SkyWars.arena.ArenaManager;
import ak.CookLoco.SkyWars.player.SkyPlayer;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="SkyWars (CookLoco) - Players in Arena")
@Description(value={"Returns the alive players in a skywars arena."})
@Examples(value={"set {players::*} to the alive players in the skywars arena named \"cool\""})
public class ExprPlayers
extends SimpleExpression<Player> {
    private Expression<String> name;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the players in SkyWars arena named " + this.name.toString(e, b);
    }

    @Nullable
    protected Player[] get(Event e) {
        Arena arena;
        if (this.name.getSingle(e) == null || (arena = ArenaManager.getGame((String)((String)this.name.getSingle(e)))) == null) {
            return null;
        }
        return (Player[])arena.getAlivePlayer().stream().map(SkyPlayer::getPlayer).toArray(Player[]::new);
    }

    static {
        Skript.registerExpression(ExprPlayers.class, Player.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [alive] players in [the] [SkyWars] arena [(named|with name)] %string%"});
    }
}

