/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Shopkeeper Location")
@Description(value={"Returns the location of a shopkeeper."})
@Examples(value={"send \"%the location of the shopkeeper with id 1\""})
public class ExprKeeperLoc
extends SimpleExpression<Location> {
    private Expression<Integer> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "location of shopkeeper with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        Shopkeeper shopkeeper;
        if (this.id.getSingle(e) == null || (shopkeeper = ShopkeepersHook.shopkeeperRegistry.getShopkeeperById(((Integer)this.id.getSingle(e)).intValue())) == null) {
            return null;
        }
        return new Location[]{shopkeeper.getLocation()};
    }

    static {
        Skript.registerExpression(ExprKeeperLoc.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] loc[ation] of [the] [shop]keeper [with ID] %integer%"});
    }
}

