/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Shopkeeper ID of Entity")
@Description(value={"Returns the shopkeeper ID of an entity."})
@Examples(value={"send \"%the shopkeeper ID of event-entity\""})
public class ExprKeeperEntity
extends SimpleExpression<Integer> {
    private Expression<Entity> entity;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.entity = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "shopkeeper ID of " + this.entity.toString(e, b);
    }

    @Nullable
    protected Integer[] get(Event e) {
        Shopkeeper shopkeeper;
        if (this.entity.getSingle(e) == null || (shopkeeper = ShopkeepersHook.shopkeeperRegistry.getShopkeeperByEntity((Entity)this.entity.getSingle(e))) == null) {
            return null;
        }
        return new Integer[]{shopkeeper.getId()};
    }

    static {
        Skript.registerExpression(ExprKeeperEntity.class, Integer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [shop]keeper ID of %entity%", "%entity%'s [shop]keeper ID"});
    }
}

