/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopchest.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import de.epiceric.shopchest.shop.Shop;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopchest.ShopChestHook;

@Name(value="ShopChest - Shop At Location")
@Description(value={"Returns the id of the shop at a location."})
@Examples(value={"send \"%the id of the shop at player%\""})
public class ExprShopAtLocation
extends SimpleExpression<Number> {
    private Expression<Location> location;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.location = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the shop at location " + this.location.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Shop shop;
        if (this.location.getSingle(e) == null || (shop = ShopChestHook.shopUtils.getShop((Location)this.location.getSingle(e))) == null) {
            return null;
        }
        return new Number[]{shop.getID()};
    }

    static {
        Skript.registerExpression(ExprShopAtLocation.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [ID of [the]] [ShopChest] shop at %location%"});
    }
}

