/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Time Until Reset")
@Description(value={"Returns the time left until a mine resets."})
@Examples(value={"send \"%the time until the mine at player resets%\""})
public class ExprTimeLeft
extends SimpleExpression<Number> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "time until reset of mine named " + this.name.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return null;
        }
        return new Number[]{PrisonMinesHook.mineAPI.getTimeUntilReset(mine)};
    }

    static {
        Skript.registerExpression(ExprTimeLeft.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [amount of] time [left] until [the] [PrisonMines] mine [(named|with name)] %string% (resets|is reset)"});
    }
}

