/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Teleport Location")
@Description(value={"Returns the teleport location of a mine."})
@Examples(value={"send \"%the teleport location of the mine at player%\""})
public class ExprTeleportLoc
extends SimpleExpression<Location> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "teleport location of mine named " + this.name.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return null;
        }
        return new Location[]{mine.getTeleportLocation()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return;
        }
        Location newLoc = (Location)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            mine.setTeleportLocation(newLoc);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{Location.class}) : null;
    }

    static {
        Skript.registerExpression(ExprTeleportLoc.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] (teleport|tp) loc[ation] of [the] [PrisonMines] mine [(named|with name)] %string%"});
    }
}

