/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot IDs of Player")
@Description(value={"Returns the plot IDs of a player."})
@Examples(value={"send \"%the plots of player%\""})
public class ExprPlotIDsOfPlayer
extends SimpleExpression<String> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "ids of plots of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (String[])PlotSquaredHook.plotAPI.getPlotSquared().getPlots(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).stream().map(plot -> plot.getId().toString()).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprPlotIDsOfPlayer.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [IDs of [all] [the]] [PlotSquared] plots of %offlineplayer%", "[(all [[of] the]|the)] [IDs of] %offlineplayer%'s [PlotSquared] plots"});
    }
}

