/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.intellectualcrafters.plot.object.Plot;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot Home")
@Description(value={"Returns the home location of a plot."})
@Examples(value={"send \"%the home location of the plot with id (id of plot at player)%\""})
public class ExprHomeLocation
extends SimpleExpression<Location> {
    private Expression<String> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "home location of plot with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        com.intellectualcrafters.plot.object.Location home = plot.getHome();
        return new Location[]{new Location(Bukkit.getWorld((String)home.getWorld()), (double)home.getX(), (double)home.getY(), (double)home.getZ(), home.getYaw(), home.getPitch())};
    }

    static {
        Skript.registerExpression(ExprHomeLocation.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] home loc[ation] of [the] [PlotSquared] plot [with ID] %string%"});
    }
}

