/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.alessiodp.parties.objects.ThePlayer;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Party of Player")
@Description(value={"Returns the party of a player."})
@Examples(value={"send \"%the party of player%\""})
public class ExprPartyOfPlayer
extends SimpleExpression<String> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "party of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        ThePlayer partyPlayer = PartiesHook.playerHandler.getThePlayer((OfflinePlayer)this.player.getSingle(e));
        return new String[]{PartiesHook.playerHandler.getPartyFromThePlayer(partyPlayer).getName()};
    }

    static {
        Skript.registerExpression(ExprPartyOfPlayer.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[[the] name of] [the] party of %offlineplayer%", "[[the] name of] %offlineplayer%'s party"});
    }
}

