/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Party Kills")
@Description(value={"Returns the amount of kills of a party."})
@Examples(value={"send \"%the kills of the party named \"cool\"%\""})
public class ExprPartyKills
extends SimpleExpression<Number> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "kills of party named " + this.name.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.name.getSingle(e) == null) {
            return null;
        }
        return new Number[]{PartiesHook.partiesAPI.getPartyKills((String)this.name.getSingle(e))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.name.getSingle(e) == null) {
            return;
        }
        int killsChange = ((Number)delta[0]).intValue();
        Integer currentKills = PartiesHook.partiesAPI.getPartyKills((String)this.name.getSingle(e));
        if (mode == Changer.ChangeMode.SET) {
            PartiesHook.partyHandler.loadParty((String)this.name.getSingle(e)).setKills(killsChange);
        } else if (mode == Changer.ChangeMode.ADD) {
            PartiesHook.partyHandler.loadParty((String)this.name.getSingle(e)).setKills(currentKills + killsChange);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            PartiesHook.partyHandler.loadParty((String)this.name.getSingle(e)).setKills(currentKills - killsChange);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprPartyKills.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [(number|amount) of] kills of [the] party [(named|with name)] %string%", "[the] party [(named|with name)] %string%'s [(number|amount) of] kills"});
    }
}

