/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.minepacks.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import us._donut_.skuniversal.minepacks.MinePacksHook;

@Name(value="MinePacks - Backpack SLot")
@Description(value={"Returns the item in a backpack slot."})
@Examples(value={"send \"%the item in slot 5 of backpack of player%\""})
public class ExprSlotItem
extends SimpleExpression<ItemStack> {
    private Expression<Integer> slotNum;
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.slotNum = e[0];
        this.player = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "item in slot " + this.slotNum.toString(e, b) + " of backpack of player " + this.player.toString(e, b);
    }

    @Nullable
    protected ItemStack[] get(Event e) {
        if (this.player.getSingle(e) == null || this.slotNum.getSingle(e) == null) {
            return null;
        }
        return new ItemStack[]{MinePacksHook.database.getBackpack((OfflinePlayer)this.player.getSingle(e)).getInventory().getItem(((Integer)this.slotNum.getSingle(e)).intValue())};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.player.getSingle(e) == null) {
                return;
            }
            MinePacksHook.database.getBackpack((OfflinePlayer)this.player.getSingle(e)).getInventory().setItem(((Integer)this.slotNum.getSingle(e)).intValue(), (ItemStack)delta[0]);
            MinePacksHook.database.getBackpack((OfflinePlayer)this.player.getSingle(e)).save();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack.class}) : null;
    }

    static {
        Skript.registerExpression(ExprSlotItem.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[[the] item in] slot %integer% of [the] (back|mine)pack of %player%", "[[the] item in] slot %integer% of %player%'s (back|mine)pack"});
    }
}

