/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.Node;
import org.bukkit.event.Event;
import us._donut_.skuniversal.luckperms.LuckPermsHook;

@Name(value="LuckPerms - Weight of Group")
@Description(value={"Returns the weight of a group."})
@Examples(value={"set {default::weight} to the weight of the luckperms group \"default\""})
public class ExprGroupWeight
extends SimpleExpression<Number> {
    private Expression<String> group;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.group = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "luckperms weight of group " + this.group.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Number[] numberArray;
        if (this.group.getSingle(e) == null) {
            return null;
        }
        Group lpGroup = LuckPerms.getApi().getGroup((String)this.group.getSingle(e));
        if (lpGroup == null) {
            return null;
        }
        if (lpGroup.getWeight().isPresent()) {
            numberArray = null;
        } else {
            Number[] numberArray2 = new Number[1];
            numberArray = numberArray2;
            numberArray2[0] = lpGroup.getWeight().getAsInt();
        }
        return numberArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.group.getSingle(e) == null) {
            return;
        }
        Group groupBeingChanged = LuckPerms.getApi().getGroup((String)this.group.getSingle(e));
        if (groupBeingChanged == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            for (Node node : groupBeingChanged.getPermissions()) {
                if (!node.getPermission().split("\\.")[0].equalsIgnoreCase("weight")) continue;
                groupBeingChanged.unsetPermission(node);
            }
            groupBeingChanged.setPermission(LuckPerms.getApi().getNodeFactory().newBuilder("weight." + String.valueOf(delta[0])).build());
            LuckPermsHook.luckpermsAPI.getGroupManager().saveGroup(groupBeingChanged);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprGroupWeight.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] (priority|weight) of [the] [LuckPerm[s]] group [(named|with name)] %string%", "[the] [LuckPerm[s]] group [(named|with name)] %string%'s (priority|weight)"});
    }
}

