/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lockettepro.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.crafter.mc.lockettepro.Config;
import me.crafter.mc.lockettepro.Utils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="LockettePro - Lock Block")
@Description(value={"Locks a block by placing a sign on it."})
@Examples(value={"place a LockettePro sign on the north face of the clicked block with player as the owner"})
public class EffLock
extends Effect {
    private Expression<String> stringFace;
    private Expression<Block> block;
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult p) {
        this.stringFace = e[0];
        this.block = e[1];
        this.player = e[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "place LockettePro sign with player " + this.player.toString(e, b) + " as the owner";
    }

    protected void execute(Event e) {
        BlockFace face;
        if (this.stringFace.getSingle(e) == null || this.block.getSingle(e) == null || this.player.getSingle(e) == null) {
            return;
        }
        switch (((String)this.stringFace.getSingle(e)).toLowerCase()) {
            case "north": {
                face = BlockFace.NORTH;
                break;
            }
            case "south": {
                face = BlockFace.SOUTH;
                break;
            }
            case "east": {
                face = BlockFace.EAST;
                break;
            }
            case "west": {
                face = BlockFace.WEST;
                break;
            }
            default: {
                face = BlockFace.NORTH;
            }
        }
        Utils.putSignOn((Block)((Block)this.block.getSingle(e)), (BlockFace)face, (String)Config.getDefaultPrivateString(), (String)((Player)this.player.getSingle(e)).getName());
    }

    static {
        Skript.registerEffect(EffLock.class, (String[])new String[]{"(put|place) [a] [LockettePro] sign on [the] %string% [block]face of %block% with owner %player%"});
    }
}

