/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Greater Corner")
@Description(value={"Returns the greater corner of a claim."})
@Examples(value={"send \"%the greater corner of the claim with id (id of the basic claim at player)%\""})
public class ExprGreaterCorner
extends SimpleExpression<Location> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "greater boundary corner of claim with id " + this.id.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        Location[] locationArray;
        Claim claim = GriefPreventionHook.getClaim(((Number)this.id.getSingle(e)).longValue());
        if (claim == null) {
            locationArray = null;
        } else {
            Location[] locationArray2 = new Location[1];
            locationArray = locationArray2;
            locationArray2[0] = claim.getGreaterBoundaryCorner();
        }
        return locationArray;
    }

    static {
        Skript.registerExpression(ExprGreaterCorner.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] greater [boundary] corner [loc[ation]] of [the] [G[rief]P[revention]] claim [with ID] %number%"});
    }
}

