/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Delete Claim")
@Description(value={"Deletes claim(s)."})
@Examples(value={"delete claims with ids (ids of the claims at player)"})
public class EffDeleteClaim
extends Effect {
    private Expression<Number> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult p) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "delete claim(s) with id(s) " + this.id.getSingle(e);
    }

    protected void execute(Event e) {
        if (this.id.getArray(e) == null) {
            return;
        }
        for (Number claimID : (Number[])this.id.getArray(e)) {
            Claim claim = GriefPreventionHook.getClaim(claimID.longValue());
            if (claim == null) {
                return;
            }
            GriefPreventionHook.dataStore.deleteClaim(claim);
        }
    }

    static {
        Skript.registerEffect(EffDeleteClaim.class, (String[])new String[]{"(delete|remove) [the] [G[rief]P[revention]] claim[s] [with ID[s]] %numbers%"});
    }
}

