/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.expressions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Cannon Load Time")
@Description(value={"Returns the time a cannon takes to load."})
@Examples(value={"send \"%the load time of the cannon with id (id of cannon at player)%\""})
public class ExprCannonLoadTime
extends SimpleExpression<Number> {
    private Expression<String> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the load time of the cannon with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Cannon cannon;
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return null;
        }
        return new Number[]{cannon.getCannonDesign().getLoadTime()};
    }

    static {
        Skript.registerExpression(ExprCannonLoadTime.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] load[ing] time of [the] cannon [with ID] %string%"});
    }
}

