/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.expressions;

import at.pavlov.cannons.cannon.CannonManager;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Cannons - Cannon IDs in Sphere")
@Description(value={"Returns the IDs of all cannons in a sphere."})
@Examples(value={"send \"%the IDs of the cannons within the sphere centered at player with radius 5%\""})
public class ExprCannonIDsInSphere
extends SimpleExpression<String> {
    private Expression<Location> center;
    private Expression<Number> radius;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.center = e[0];
        this.radius = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the IDs of the cannons within the sphere centered at " + this.center.toString(e, b) + " with radius " + this.radius.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.center.getSingle(e) == null || this.radius.getSingle(e) == null) {
            return null;
        }
        return (String[])CannonManager.getCannonsInSphere((Location)((Location)this.center.getSingle(e)), (double)((Number)this.radius.getSingle(e)).doubleValue()).stream().map(cannon -> cannon.getUID().toString()).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprCannonIDsInSphere.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)]] [IDs of [the]] cannons [with]in [the] sphere centered at %location%[,] [with] radius %number%"});
    }
}

