/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.conditions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Is Cannon Ready to Fire")
@Description(value={"Checks if a cannon is ready to fire."})
@Examples(value={"if the cannon with id (id of cannon at player) is ready to fire:"})
public class CondReadyToFire
extends Condition {
    private Expression<String> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "cannon with ID " + this.id.toString(e, b) + " is ready to fire";
    }

    public boolean check(Event e) {
        Cannon cannon;
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return this.isNegated();
        }
        return cannon.isReadyToFire() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondReadyToFire.class, (String[])new String[]{"[the] cannon [with ID] %string% is ready to (fire|be fired)", "[the] cannon [with ID] %string% is(n't| not) ready to (fire|be fired)"});
    }
}

