/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.conditions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Is Projectile Loaded")
@Description(value={"Checks if a projectile is loaded in a cannon."})
@Examples(value={"if a projectile is loaded in the cannon with id (id of cannon at player):"})
public class CondProjectileLoaded
extends Condition {
    private Expression<String> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        this.setNegated(matchedPattern == 2 || matchedPattern == 3);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "a projectile is loaded in the cannon with id " + this.id.toString(e, b);
    }

    public boolean check(Event e) {
        Cannon cannon;
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return this.isNegated();
        }
        return cannon.isProjectileLoaded() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondProjectileLoaded.class, (String[])new String[]{"[a] projectile is loaded in [the] cannon [with ID] %string%", "[the] cannon [with ID] %string% is loaded", "[a] projectile is(n't| not) loaded in [the] cannon [with ID] %string%", "[the] cannon [with ID] %string% is(n't| not) loaded"});
    }
}

